VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4308
   ClientLeft      =   48
   ClientTop       =   336
   ClientWidth     =   9600
   LinkTopic       =   "Form1"
   ScaleHeight     =   4308
   ScaleWidth      =   9600
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton AutoExposureButton 
      Caption         =   "Auto Exposure"
      Height          =   252
      Left            =   720
      TabIndex        =   11
      Top             =   2760
      Width           =   1332
   End
   Begin VB.CommandButton UltracalButton 
      Caption         =   "Ultracal"
      Height          =   252
      Left            =   720
      TabIndex        =   10
      Top             =   2040
      Width           =   732
   End
   Begin VB.TextBox Counter 
      Height          =   288
      Left            =   3600
      TabIndex        =   9
      Text            =   "Counter"
      Top             =   3480
      Width           =   972
   End
   Begin VB.TextBox Ticks 
      Height          =   288
      Left            =   1800
      TabIndex        =   8
      Text            =   "Ticks"
      Top             =   3480
      Width           =   972
   End
   Begin VB.TextBox Text1 
      Height          =   288
      Left            =   4080
      TabIndex        =   7
      Text            =   "Text1"
      Top             =   960
      Width           =   1092
   End
   Begin VB.CommandButton StopButton 
      Caption         =   "Stop"
      Height          =   252
      Left            =   720
      TabIndex        =   6
      Top             =   1080
      Width           =   732
   End
   Begin VB.CommandButton StartButton 
      Caption         =   "Start"
      Height          =   252
      Left            =   720
      TabIndex        =   5
      Top             =   600
      Width           =   732
   End
   Begin VB.TextBox CentroidY 
      Height          =   288
      Left            =   2280
      TabIndex        =   1
      Text            =   "CentroidY"
      Top             =   1200
      Width           =   1212
   End
   Begin VB.TextBox CentroidX 
      Height          =   288
      Left            =   2280
      TabIndex        =   0
      Text            =   "CentroidX"
      Top             =   720
      Width           =   1212
   End
   Begin VB.Label Label3 
      Caption         =   "Beam Image"
      Height          =   252
      Left            =   6000
      TabIndex        =   4
      Top             =   360
      Width           =   1452
   End
   Begin VB.Label Label2 
      Caption         =   "Frame Data"
      Height          =   252
      Left            =   4080
      TabIndex        =   3
      Top             =   360
      Width           =   1332
   End
   Begin VB.Label Label1 
      Caption         =   "Some Results"
      Height          =   252
      Left            =   2280
      TabIndex        =   2
      Top             =   360
      Width           =   1212
   End
   Begin VB.Image Image1 
      BorderStyle     =   1  'Fixed Single
      Height          =   3252
      Left            =   6000
      Stretch         =   -1  'True
      Top             =   720
      Width           =   3252
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Base 0

Private Const vbDIB_RGB_COLORS = 0
Private Const vbDIB_PAL_COLORS = 1

Private Type GUID
    Data1 As Long
    Data2 As Integer
    Data3 As Integer
    Data4(7) As Byte
End Type

Private Type PicBmp
    SIZE As Long
    Type As Long
    hBmp As Long
    hPal As Long
    Reserved As Long
End Type

Private Declare Function CreateCompatibleDC Lib "gdi32" ( _
                    ByVal hDC As Long _
                    ) As Long

Private Declare Function CreateDIBSection Lib "gdi32" ( _
                    ByVal hDC As Long, _
                    pBitmapInfo As Any, _
                    ByVal un As Long, _
                    lpVoid As Any, _
                    ByVal handle As Long, _
                    ByVal dw As Long) As Long

Private Declare Function DeleteDC Lib "gdi32" ( _
                    ByVal hDC As Long _
                    ) As Long
    
Private Declare Function GetLastError Lib "kernel32" () As Long

Private Declare Function OleCreatePictureIndirect Lib "olepro32.dll" ( _
                    PicDesc As PicBmp, _
                    RefIID As GUID, _
                    ByVal fPictureOwnsHandle As Long, _
                    IPic As IPicture _
                    ) As Long

Private Declare Function RealizePalette Lib "gdi32" ( _
                    ByVal hDC As Long _
                    ) As Long

Private Declare Function SelectObject Lib "gdi32" ( _
                    ByVal hDC As Long, _
                    ByVal hObject As Long _
                    ) As Long

Private Declare Function SetDIBits Lib "gdi32" ( _
                    ByVal hDC As Long, _
                    ByVal hBitmap As Long, _
                    ByVal nStartScan As Long, _
                    ByVal nNumScans As Long, _
                    lpBits As Any, _
                    lpBI As Any, _
                    ByVal wUsage As Long _
                    ) As Long

Private Declare Function GetCurrentTime Lib "kernel32" Alias "GetTickCount" () As Long
Dim LastTickCount As Long
Dim EventCount As Long

'   Declare a variable to hold the LBA-PC ActiveX server object
'   If you want to respond to events then you must include WithEvents
'
Dim WithEvents LbapcActiveX As LbapcX.LbapcActiveX
Attribute LbapcActiveX.VB_VarHelpID = -1

'   Sub UltracalButton_Click
'       Calls LbapcActiveX.Ultracal to start LBA-PC data collection.
'
Private Sub AutoExposureButton_Click()
    e = LbapcActiveX.AutoExposure
    Select Case (e)
        Case -1
            MsgBox "You must start LBA-PC."
        Case 1
            MsgBox "Ultracal or Auto Exposure is not complete."
    End Select
End Sub

'   Sub Form_Load
'       Event called when the form is loaded
'
'   Here we want to create a new LBA-PC ActiveX server object and
'       open the connection to LBA-PC.
'   You might want to include some error handling in case there is a problem creating
'       the LBA-PC ActiveX server object (e.g. not registered, etc.)
'
Private Sub Form_Load()
    Set LbapcActiveX = New LbapcX.LbapcActiveX
'Set LbapcActiveX = CreateObject("LbapcX.LbapcActiveX", "test")
    
    '   If LbapcActiveX.Open returns a value other than 0, then the connection was
    '       not opened because of a problem (e.g. LBA-PC not running)
    '
    e = LbapcActiveX.Open
    If (e = -1) Then
        MsgBox "You must start LBA-PC."
    End If
End Sub

'   Sub NewBitmap
'       Converts current LbapcActiveX.Bitmap to a Picture object.  Assigns new picture
'           object to Image1.Picture
'
Private Sub NewBitmap()
    Dim e As Long
    
    '   get a local copy of the LbapcActiveX.Bitmap array
    '
    '   the format of the LbapcActiveX.Bitmap array is
    '       BitmapInfoHeader            Windows BITMAPINFOHEADER structure
    '       Palette                     256 element array of Windows PALETTEENTRY
    '       Bits                        Two dimensional array of byte.
    '
    Dim Bits() As Long
        Bits = LbapcActiveX.Bitmap

    '   create a memory DC compatible with the current screen
    '
    Dim hDC As Long
        hDC = CreateCompatibleDC(0)
    
    '   create a bitmap to hold the Bits() array
    '
    '   parameters passed to CreateDIBSection are as follows:
    '       hDC             handle to DC.  pass the handle to our memory DC
    '       pBitmapInfo     pointer to BITMAPINFO structure.  a BITMAPINFO structure
    '                       consists of a BITMAPINFOHEADER header followed by an array
    '                       of RGBQUAD.  this is _exactly_ the format of the
    '                       LbapcActiveX.Bitmap array.  so just pass the address of the
    '                       first element of the array.
    '       un              color data type indicator.  in our case the BITMAPINFO
    '                       structure contains an array of literal RGB values.
    '       lpVoid          returns a pointer to the location of the bits.  not used.
    '       handle          handle to file mapping section.  not used.
    '       dw              offset to bitmap bit values.  not used.
    '
    Dim hBitmap As Long
    Dim pBits As Long
        hBitmap = CreateDIBSection(hDC, Bits(0), vbDIB_RGB_COLORS, pBits, 0, 0)

    '   if our bitmap was created successfully then
    '       - select the bitmap into our memory DC
    '       - copy Bits() to the bitmap
    '       - restore the previous bitmap
    '       - return the memory DC to the system
    '
    If (hBitmap <> 0) Then
        Dim hBitmapPrev As Long
            hBitmapPrev = SelectObject(hDC, hBitmap)
        
        '   copy Bits() to the bitmap
        '
        '   parameters passed to SetDIBits are as follows:
        '
        '       hDC             handle to DC.  pass the handle to our memory DC
        '
        '       hBitmap         handle to the bitmap.
        '
        '       nStartScan      starting scan line.  row where the copy will start.
        '
        '       nNumScans       number scan lines.  number of rows to copy.  here we
        '                       pass the value at Bits(2) which corresponds to the
        '                       biHeight item in the BITMAPINFOHEADER structure.
        '
        '                       Note, we take the absolute value, Abs(Bits(2)).  The
        '                       biHeight value can be positive if the bitmap is stored
        '                       upside down in memory or negative to indicate the bitmap
        '                       is stored right side up in memory.  We take the absolute
        '                       value to ensure the value we pass is positive.
        '
        '       lpBits          pointer to bits to be copied.  the BITMAPINFOHEADER is
        '                       40 bytes which is 10 array elements in Bits() since Bits()
        '                       is declared as Long.  the palette array has 256 elements.
        '                       so the bits from LbapcActiveX.Bitmap start at array
        '                       location 10+256=266.
        '
        '       lpBI            pointer to BITMAPINFO structure.  a BITMAPINFO structure
        '                       consists of a BITMAPINFOHEADER header followed by an array
        '                       of RGBQUAD.  this is _exactly_ the format of the
        '                       LbapcActiveX.Bitmap array.  so just pass the address of the
        '                       first element of the array.
        '
        '       wUsage          type of color indexes to use.  in our case the BITMAPINFO
        '                       structure contains an array of literal RGB values.
        '
        e = SetDIBits(hDC, hBitmap, 0, Abs(Bits(2)), Bits(266), Bits(0), vbDIB_RGB_COLORS)
        
        hBitmap = SelectObject(hDC, hBitmapPrev)
        e = DeleteDC(hDC)
    Else
        MsgBox ("CreateDIBSection failed. Error " & CStr(GetLastError))
        Exit Sub
    End If

    '   OleCreatePictureIndirect creates a Picture object from a bitmap
    '
    '   parameters passed to OleCreatePictureIndirect are as follows:
    '
    '       PicDesc             pointer to a PICTDESC structure.  this structure describes
    '                           the source used to create the picture.  in our case we
    '                           specify a bitmap source and pass the handle to the bitmap.
    '       RefIID              the type of interface pointer to return.  IID_IDispatch is
    '                           a standard object interface pointer.
    '       fPictureOwnsHandle  if TRUE, the picture object is to destroy its picture when
    '                           the object is destroyed.  in other words, we want the
    '                           picture object to destroy the bitmap when the picture
    '                           object is destroyed.
    '       IPic                address of output variable that receives the interface
    '                           pointer specified in RefIID.
    '
    Dim Pic As PicBmp
        Pic.SIZE = Len(Pic)
        Pic.Type = vbPicTypeBitmap
        Pic.hBmp = hBitmap
        Pic.hPal = 0
    Dim IID_IDispatch As GUID
        IID_IDispatch.Data1 = &H20400
        IID_IDispatch.Data4(0) = &HC0
        IID_IDispatch.Data4(7) = &H46
    Dim IPic As IPictureDisp
    r = OleCreatePictureIndirect(Pic, IID_IDispatch, 1, IPic)
    
    '   display the new picture
    '
    Set Image1.Picture = IPic
    
End Sub

'   Sub LbapcActiveX_OnNewFrame
'       Event called each time the LBA-PC collects a new frame of data.
'
Private Sub LbapcActiveX_OnNewFrame()
    '   display some results
    '
    CentroidX = Format(LbapcActiveX.Results(6), "0.000e+00")
    CentroidY = Format(LbapcActiveX.Results(7), "0.000e+00")
    
    '   display one pixel of data (upper-left corner)
    '
    Text1 = LbapcActiveX.FrameData(0, 0)
    
    '   convert the new bitmap to a picture and display it
    '
    NewBitmap
    
    '   display how many ticks (milliseconds) since the last event
    '
    TickCount = GetCurrentTime
    Ticks = TickCount - LastTickCount
    LastTickCount = TickCount
    
    '   display number of total events
    '
    EventCount = EventCount + 1
    Counter = EventCount
End Sub

'   Sub StartButton_Click
'       Calls LbapcActiveX.Start to start LBA-PC data collection.
'
Private Sub StartButton_Click()
    e = LbapcActiveX.Start
    Select Case (e)
        Case -1
            MsgBox "You must start LBA-PC."
        Case 1
            MsgBox "Ultracal or Auto Exposure is not complete."
    End Select
End Sub

'   Sub StopButton_Click
'       Calls LbapcActiveX.Stop to stop LBA-PC data collection.
'
Private Sub StopButton_Click()
    LbapcActiveX.Stop
End Sub

'   Sub UltracalButton_Click
'       Calls LbapcActiveX.Ultracal to start LBA-PC data collection.
'
Private Sub UltracalButton_Click()
    e = LbapcActiveX.Ultracal
    Select Case (e)
        Case -1
            MsgBox "You must start LBA-PC."
        Case 1
            MsgBox "Ultracal or Auto Exposure is not complete."
    End Select
End Sub
